@extends('layouts.app')

@section('title', '403 Forbidden')

@section('content')
<div class="error-container">
    <div class="error-image">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" class="feather feather-lock">
            <rect x="3" y="11" width="18" height="11" rx="2" ry="2" fill="rgba(255,255,255,0.1)" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></rect>
            <path d="M7 11V7a5 5 0 0 1 10 0v4" stroke="{{ config('variables.primary-color', '#3d84ff') }}"></path>
            <circle cx="12" cy="16" r="1" fill="{{ config('variables.primary-color', '#3d84ff') }}"></circle>
        </svg>
    </div>
    
    <h1 class="error-code">403</h1>
    <h2 class="error-title">Access Denied</h2>
    
    <p class="error-message">
        You don't have permission to access this page. If you believe this is a mistake, please contact an administrator or try signing in with a different account.
    </p>
    
    <div class="error-actions">
        @guest
            <a href="{{ route('login.steam') }}" class="btn btn-secondary">Sign In</a>
        @else
            <a href="{{ url()->previous() }}" class="btn btn-primary">Go Back</a>
        @endguest
    </div>
</div>
@endsection